{{ *****************************************************
   *  Example1.2    : For "ET-BASE PX32 V1.0           *
   *                                                   *
   *  File Name   : Ex1.2_TV_TextGPH.spin              *
   *  Compiler    : Propeller V1.06                    *
   *  Create By   : Sittiphol Yooyod (www.ett.co.th)   *
   *  Last Update : 28/January/2007                    *
   *  Function    : Display Text Graphic to TV         *                  
   *                                                   *
   ***************************************************** }}


CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000
  _stack = ($3000 + $3000 + 100) >> 2   'accomodate display memory and stack

  x_tiles = 16
  y_tiles = 12

  paramcount = 14       
  bitmap_base = $2000
  display_base = $5000

  lines = 5
  thickness = 2
  

VAR

  'long  mousex, mousey

  long  tv_status     '0/1/2 = off/visible/invisible           read-only
  long  tv_enable     '0/? = off/on                            write-only
  long  tv_pins       '%ppmmm = pins                           write-only
  long  tv_mode       '%ccinp = chroma,interlace,ntsc/pal,swap write-only
  long  tv_screen     'pointer to screen (words)               write-only
  long  tv_colors     'pointer to colors (longs)               write-only               
  long  tv_hc         'horizontal cells                        write-only
  long  tv_vc         'vertical cells                          write-only
  long  tv_hx         'horizontal cell expansion               write-only
  long  tv_vx         'vertical cell expansion                 write-only
  long  tv_ho         'horizontal offset                       write-only
  long  tv_vo         'vertical offset                         write-only
  long  tv_broadcast  'broadcast frequency (Hz)                write-only
  long  tv_auralcog   'aural fm cog                            write-only

  word  screen[x_tiles * y_tiles]
  long  colors[64]


OBJ

  tv    : "tv"
  gr    : "graphics"
 


PUB main | i,x,y,count,numcha0,numcha1,numcha2


  '-------------------- start tv -------------
  longmove(@tv_status, @tvparams, paramcount)
  tv_screen := @screen
  tv_colors := @colors
  tv.start(@tv_status)

  '-------------- init colors ------------
 
  repeat i from $00 to $0F    
    colors[i] := $58089802    ''keep Color:$58=Red,$08=Green,$98=Blue,Back Ground $02= Black  
  repeat i from $10 to $1F  
    colors[i] := $58780798    ''keep Color:$58=Red,$78=Violet,$07=white,Back Ground $98= Blue 
  repeat i from $20 to $2F
    colors[i] := $98080258    ''keep Color:$98=Blue,$08=Green,$02=Black,Back Ground $58= Red
  repeat i from $30 to $3F
    colors[i] := $68580708    ''keep Color:$98=Pink,$58=Red,$07=White,Back Ground $08= Green 

  
  '----------- initial tile screen ----------
  
  repeat x from 0 to tv_hc - 1
    repeat y from 0 to tv_vc - 1
      case y
        0..2 : i :=       x
        3..5 : i := $10 + x
        6..8 : i := $20 + x 
        9..11: i := $30  + x
        other: i := 0
      screen[x + y * tv_hc] := i << 10 + display_base >> 6 + x * tv_vc + y



  '----------- start and setup graphics ------------
  gr.start
  gr.setup(16, 12, 128, 96, bitmap_base)

  
  '----------- Write Text ---------
repeat
   'clear bitmap
    gr.clear
    'Text "ETT DEMO"
    gr.textmode(2,2,7,5)       ''Set Text Size 
    gr.colorwidth(3,3)         ''Set Pixel Color and Width
    gr.text(0,85,@str0)        ''Set Position Text x,y on TV and Pointer to str0

    'Text "GRAPHIC TEXT ON TV"
    gr.textmode(2,1,7,5)       ''Set Text Size 
    gr.colorwidth(2,2)         ''Set Pixel Color and Width
    gr.text(0,60,@str1)        ''Set Position Text x,y on TV and Pointer to str1

    'Text "Hello" Color white
    gr.textmode(2,2,7,5)       ''Set Text Size 
    gr.colorwidth(1,2)         ''Set Pixel Color and Width
    gr.text(-75,25,@str2)      ''Set Position Text x,y on TV and Pointer to str2

    'Text "Hello" Color Red
    gr.textmode(3,3,7,5)       ''Set Text Size 
    gr.colorwidth(3,4)         ''Set Pixel Color and Width
    gr.text(65,25,@str2)       ''Set Position Text x,y on TV and Pointer to str2


    'Text "Hello" Color Black
    gr.textmode(2,2,7,5)       ''Set Text Size 
    gr.colorwidth(1,17)        ''Set Pixel Color and Width
    gr.text(-75,-25,@str2)     ''Set Position Text x,y on TV and Pointer to str2

    'Text "Hello" Color Blue
    gr.textmode(3,3,7,5)       ''Set Text Size 
    gr.colorwidth(3,19)        ''Set Pixel Color and Width
    gr.text(65,-25,@str2)      ''Set Position Text x,y on TV and Pointer to str2

    
   'Draw small box with text "www.ett.co.th"
    gr.colorwidth(1,14)
    gr.box(18,-93,105,25)
    gr.textmode(1,2,7,5)
    gr.colorwidth(2,17)
    gr.text(70,-80,@str3)
   
    
    'draw incrementing digit

         numcha0++
      if numcha0 < "0" or numcha0 > "9"
         numcha0 := "0"
      gr.textmode(3,4,7,5)
      gr.colorwidth(3,5)
      gr.text(-47,-72,@numcha0)


      if numcha0 == "0"
         numcha1++
      if numcha1 < "0" or numcha1 > "9"
         numcha1 := "0"
      gr.textmode(3,4,7,5)
      gr.colorwidth(3,5)
      gr.text(-72,-72,@numcha1)
        

      if numcha0 == "0"
         if numcha1 == "0"
            numcha2++
      if numcha2 < "0" or numcha2 > "9"
         numcha2 := "0"
      gr.textmode(3,4,7,5)
      gr.colorwidth(3,5)
      gr.text(-95,-72,@numcha2)
      
      
  '------- copy bitmap to TV --------
      gr.copy(display_base)
      
      WaitCnt(40_000_000 + Cnt) ''delay 500 ms
  
    

DAT

tvparams                long    0               'status
                        long    1               'enable
                        long    %001_0101       'pins
                        long    %0000           'mode
                        long    0               'screen
                        long    0               'colors
                        long    x_tiles         'hc
                        long    y_tiles         'vc
                        long    10              'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    0               'broadcast
                        long    0               'auralcog

 

str0                    byte "ETT DEMO",0
str1                    byte "GRAPHIC TEXT ON TV",0
str2                    byte "Hello! ",0
str3                    byte "www.ett.co.th",0